/****** Object:  StoredProcedure [hips].[PatientMasterByDemographicsByHospitalGet]    Script Date: 19/12/2014 23:31:34 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterDemographicsByHospitalGet]') AND type in (N'P', N'PC'))
DROP PROCEDURE [hips].[PatientMasterDemographicsByHospitalGet]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:        Kirby Bettison
-- Create date:   23/10/2013
-- Description:   Gets a specific record from the Patient Master table.
--
-- Lookup Types Supported:
--    1. Demographic search using all of:
--         CurrentLastName, CurrentFirstNames, DateOfBirth, CurrentSexId
--       and one of:
--           DvaNumber, MedicareNumber
--       and optionally MedicareIrn.
--       For demographic search the business logic must pass a valid medicare
--       number or null, but avoid passing a special value like '8' or '0',
--       which could match records that it should not match.
--
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterDemographicsByHospitalGet] 
(
	@HospitalId INT,
	@CurrentLastName VARCHAR(80) = NULL,
	@CurrentFirstNames VARCHAR(80) = NULL,
	@DateOfBirth DATETIME = NULL,
	@CurrentSexId INT = NULL,
	@MedicareNumber VARCHAR(12) = NULL,
	@MedicareIrn VARCHAR(3) = NULL,
	@DvaNumber VARCHAR(18) = NULL
)
AS
BEGIN
	SELECT pm.[PatientMasterId]
		 , COALESCE (pmi.RegisteredSexId,pm.CurrentSexId, -1) AS RegisteredSexId
		 , COALESCE (pm.CurrentSexId, -1) AS CurrentSexId
		 , pmi.Ihi
		 , COALESCE (pmi.IhiStatusId, -1) AS IhiStatusId
		 , ihis.Description AS IhiStatus
		 , COALESCE (pmi.IhiRecordStatusId, -1) AS IhiRecordStatusId
		 , pmi.[RegisteredFamilyName]
		 , pmi.[RegisteredGivenName]
		 , irs.Description AS IhiRecordStatus
		 , pmi.DateLastValidated AS IhiLastValidated
		 , pm.[MedicareNumber]
		 , pm.[MedicareIrn]
		 , pm.[IsMedicareNumberValid]
		 , pm.[DvaNumber]
		 , pm.[StatePatientId]
		 , pm.[DateOfBirth]
		 , pm.[DateOfDeath]
		 , pm.[DeathIndicatorId]
		 , pm.[DateCreated]
		 , pm.[UserCreated]
		 , pm.[DateModified]
		 , pm.[UserModified]
    FROM	[hips].[PatientMaster] AS pm
    LEFT JOIN [hips].[PatientMasterIhi] AS pmi ON pmi.[PatientMasterID] = pm.[PatientMasterID]
    LEFT JOIN [hips].HospitalPatient AS p ON pm.PatientMasterID = p.PatientMasterID
	LEFT JOIN [hips].[Hospital] AS h ON h.HospitalID = p.HospitalID
	LEFT JOIN [hips].PatientMasterName pmn ON pmn.PatientMasterId = pm.PatientMasterId AND pmn.NameTypeId = 2
	LEFT JOIN [hips].IhiRecordStatus AS irs on irs.IhiRecordStatusId = pmi.IhiRecordStatusId
	LEFT JOIN [hips].IhiStatus AS ihis on ihis.IhiStatusId = pmi.IhiStatusId
	
    WHERE	(pmn.[FamilyName] = @CurrentLastName)
	AND		(pmn.[GivenNames] = @CurrentFirstNames)
	AND		(pm.[DateOfBirth] = @DateOfBirth)
	AND		(pm.[CurrentSexID] = @CurrentSexID)
	AND		(@DvaNumber IS NULL OR pm.[DvaNumber] = @DvaNumber)
	-- The business logic must ensure that special values (invalid/ineligible) are passed in as null to avoid matching
	AND		(@MedicareNumber IS NULL OR pm.[MedicareNumber] = @MedicareNumber)

	-- Do match even if the record has a null sequence number
	AND		(@MedicareIrn IS NULL OR pm.[MedicareIrn] IS NULL OR pm.[MedicareIrn] = @MedicareIrn)
	AND		h.HospitalId = @HospitalId

END

GO

